<?php
session_start();
include 'config.php';

if(!isset($_SESSION['admin_id'])){
    header("Location: login.php");
    exit;
}

// Handle delete action
if(isset($_GET['delete_id'])){
    $delete_id = $_GET['delete_id'];
    $stmt = $conn->prepare("DELETE FROM product WHERE id=?");
    $stmt->bind_param("i", $delete_id);
    $stmt->execute();
    $stmt->close();
    header("Location: admin_dashboard.php");
    exit;
}

// Fetch all products
$result = $conn->query("SELECT * FROM product ORDER BY id DESC");
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Admin Dashboard</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<style>
body { padding-top: 70px; }
.product-img { width: 80px; height: 80px; object-fit: cover; }
</style>
</head>
<body>

<!-- Navbar -->
<nav class="navbar navbar-expand-lg navbar-dark bg-dark fixed-top">
  <div class="container">
    <a class="navbar-brand" href="admin_dashboard.php">Admin Panel</a>
    <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
      <span class="navbar-toggler-icon"></span>
    </button>
    <div class="collapse navbar-collapse" id="navbarNav">
      <ul class="navbar-nav ms-auto">
        <li class="nav-item"><span class="navbar-text text-white me-3">Welcome, <?= $_SESSION['admin_name'] ?></span></li>
        <li class="nav-item"><a class="nav-link btn btn-sm btn-success text-white" href="add_product.php">➕ Add Product</a></li>
        <li class="nav-item"><a class="nav-link" href="admin_orders.php">📦 Orders</a></li>

        <li class="nav-item"><a class="nav-link" href="logout.php">Logout</a></li>
      </ul>
    </div>
  </div>
</nav>

<div class="container py-4">
<h2 class="mb-4">Products List</h2>

<table class="table table-bordered table-striped">
<thead class="table-dark">
<tr>
<th>ID</th>
<th>Name</th>
<th>Image</th>
<th>Price</th>
<th>Description</th>
<th>Actions</th>
</tr>
</thead>
<tbody>
<?php if($result->num_rows > 0): ?>
    <?php while($row = $result->fetch_assoc()): ?>
    <tr>
        <td><?= $row['id'] ?></td>
        <td><?= htmlspecialchars($row['name']) ?></td>
        <td>
            <?php if($row['image']): ?>
                <img src="data:image/jpeg;base64,<?= base64_encode($row['image']) ?>" class="product-img">
            <?php endif; ?>
        </td>
        <td>₹<?= number_format($row['price'],2) ?></td>
        <td><?= htmlspecialchars($row['description']) ?></td>
        <td>
            <a href="edit_product.php?id=<?= $row['id'] ?>" class="btn btn-sm btn-warning">Edit</a>
            <a href="admin_dashboard.php?delete_id=<?= $row['id'] ?>" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure you want to delete this product?')">Delete</a>
        </td>
    </tr>
    <?php endwhile; ?>
<?php else: ?>
    <tr><td colspan="6" class="text-center">No products found.</td></tr>
<?php endif; ?>
</tbody>
</table>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
