<?php
session_start();
include 'config.php';

if(!isset($_SESSION['admin_id'])){
    header("Location: login.php");
    exit;
}

// Agar koi product ID na mile to redirect kar do
if(!isset($_GET['id'])){
    header("Location: admin_dashboard.php");
    exit;
}

$product_id = $_GET['id'];

// Product fetch karna
$stmt = $conn->prepare("SELECT * FROM product WHERE id=?");
$stmt->bind_param("i", $product_id);
$stmt->execute();
$result = $stmt->get_result();
$product = $result->fetch_assoc();
$stmt->close();

if(!$product){
    echo "Product not found!";
    exit;
}

// Update Product
if($_SERVER["REQUEST_METHOD"] == "POST"){
    $name = $_POST['name'];
    $price = $_POST['price'];
    $description = $_POST['description'];

    // Agar image change ki gayi hai
    if(isset($_FILES['image']['tmp_name']) && $_FILES['image']['tmp_name'] != ""){
        $image = file_get_contents($_FILES['image']['tmp_name']);
        $stmt = $conn->prepare("UPDATE product SET name=?, price=?, description=?, image=? WHERE id=?");
        $stmt->bind_param("sdssi", $name, $price, $description, $image, $product_id);
    } else {
        $stmt = $conn->prepare("UPDATE product SET name=?, price=?, description=? WHERE id=?");
        $stmt->bind_param("sdsi", $name, $price, $description, $product_id);
    }

    if($stmt->execute()){
        header("Location: admin_dashboard.php");
        exit;
    } else {
        echo "Error updating product.";
    }
    $stmt->close();
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Edit Product</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<style>
body { padding-top: 70px; }
.product-img { width: 100px; height: 100px; object-fit: cover; }
</style>
</head>
<body>

<!-- Navbar -->
<nav class="navbar navbar-expand-lg navbar-dark bg-dark fixed-top">
  <div class="container">
    <a class="navbar-brand" href="admin_dashboard.php">Admin Panel</a>
  </div>
</nav>

<div class="container py-4">
<h2 class="mb-4">Edit Product</h2>

<form method="POST" enctype="multipart/form-data">
  <div class="mb-3">
    <label class="form-label">Name</label>
    <input type="text" name="name" class="form-control" value="<?= htmlspecialchars($product['name']) ?>" required>
  </div>

  <div class="mb-3">
    <label class="form-label">Price</label>
    <input type="number" step="0.01" name="price" class="form-control" value="<?= $product['price'] ?>" required>
  </div>

  <div class="mb-3">
    <label class="form-label">Description</label>
    <textarea name="description" class="form-control" rows="3" required><?= htmlspecialchars($product['description']) ?></textarea>
  </div>

  <div class="mb-3">
    <label class="form-label">Current Image</label><br>
    <?php if($product['image']): ?>
        <img src="data:image/jpeg;base64,<?= base64_encode($product['image']) ?>" class="product-img mb-2">
    <?php else: ?>
        <p>No image available</p>
    <?php endif; ?>
    <input type="file" name="image" class="form-control">
    <small class="text-muted">Upload only if you want to change the image.</small>
  </div>

  <button type="submit" class="btn btn-primary">Update Product</button>
  <a href="admin_dashboard.php" class="btn btn-secondary">Cancel</a>
</form>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
