<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Art Exhibition - Home</title>
  <!-- Bootstrap CSS -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    body {
      background-color: pink;
      padding-top: 70px; /* So content doesn't hide behind fixed navbar */
    }

    /* Stylish Navbar */
    .stylish-navbar {
      background: linear-gradient(90deg, #ff4e50, #f9d423);
      box-shadow: 0 4px 12px rgba(0,0,0,0.2);
      transition: background 0.3s ease-in-out;
    }

    .stylish-navbar .nav-link {
      color: white !important;
      margin: 0 8px;
      font-weight: 500;
      position: relative;
    }

    .stylish-navbar .nav-link::after {
      content: '';
      display: block;
      width: 0;
      height: 2px;
      background: white;
      transition: width .3s;
      margin: auto;
    }

    .stylish-navbar .nav-link:hover::after {
      width: 100%;
    }

    .stylish-navbar .navbar-brand {
      font-family: 'Georgia', serif;
      color: white !important;
      letter-spacing: 1px;
      font-size: 1.5rem;
    }

    .stylish-navbar .navbar-toggler {
      border: none;
    }

    .hero {
      background: url('image/banner.jpg') no-repeat center center/cover;
      height: 70vh;
      display: flex;
      justify-content: center;
      align-items: center;
      color: black;
      text-shadow: 1px 1px 4px rgba(0,0,0,0.7);
    }

    .hero h1 {
      font-size: 3rem;
    }

    .art-card img {
      height: 200px;
      object-fit: cover;
      cursor: pointer; /* pointer cursor for clickable images */
      transition: transform 0.3s ease;
    }

    .art-card img:hover {
      transform: scale(1.05);
    }

    /* Stylish Footer */
    .stylish-footer {
      background: linear-gradient(90deg, #f9d423, #ff4e50);
      color: white;
      padding: 40px 0 20px;
      text-align: center;
      position: relative;
    }

    .stylish-footer small {
      display: block;
      margin-top: 15px;
      opacity: 0.9;
    }
  </style>
</head>
<body>

<!-- Navbar -->
<nav class="navbar navbar-expand-lg navbar-dark stylish-navbar fixed-top">
  <div class="container">
    <a class="navbar-brand fw-bold fs-4" href="index.php">🎨 Art Exhibition</a>
    <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
      <span class="navbar-toggler-icon"></span>
    </button>
    
    <div class="collapse navbar-collapse justify-content-end" id="navbarNav">
      <ul class="navbar-nav">
        <li class="nav-item"><a class="nav-link active" href="index.php">Home</a></li>
        <li class="nav-item"><a class="nav-link" href="gallery.php">Gallery</a></li>
        <li class="nav-item"><a class="nav-link" href="#about">About</a></li>
        <li class="nav-item"><a class="nav-link" href="login.php">Login</a></li>
        <li class="nav-item"><a class="nav-link" href="admin_login.php">Admin</a></li>
      </ul>
    </div>
  </div>
</nav>

<!-- Hero Section -->
<section class="hero">
  <div class="text-center">
    <h1>Welcome to the Art Exhibition</h1>
    <p>Discover stunning artwork from talented artists worldwide</p>
    <a href="gallery.php" class="btn btn-primary btn-lg mt-3">View Gallery</a>
  </div>
</section>

<!-- About Section -->
<section id="about" class="container py-5">
  <div class="row text-center mb-4">
    <div class="col">
      <h2>About the Exhibition</h2>
      <p>Experience a collection of paintings, sculptures, and digital art curated for art lovers.</p>
    </div>
  </div>
  
  <!-- Featured Art (clickable images) -->
  <div class="row">
    <div class="col-md-4 mb-4">
      <div class="card art-card shadow-sm">
        <a href="gallery.php">
          <img src="image/banner1.jpg" class="card-img-top" alt="Art 1">
        </a>
        <div class="card-body text-center">
          <h5 class="card-title">Sunset Beauty</h5>
          <p class="card-text">A masterpiece that captures nature's essence.</p>
        </div>
      </div>
    </div>

    <div class="col-md-4 mb-4">
      <div class="card art-card shadow-sm">
        <a href="gallery.php">
          <img src="https://images.unsplash.com/photo-1505678261036-a3fcc5e884ee" class="card-img-top" alt="Art 2">
        </a>
        <div class="card-body text-center">
          <h5 class="card-title">Colorful Dreams</h5>
          <p class="card-text">An abstract art piece that sparks imagination.</p>
        </div>
      </div>
    </div>

    <div class="col-md-4 mb-4">
      <div class="card art-card shadow-sm">
        <a href="gallery.php">
          <img src="https://images.unsplash.com/photo-1523413651479-597eb2da0ad6" class="card-img-top" alt="Art 3">
        </a>
        <div class="card-body text-center">
          <h5 class="card-title">Urban Vibes</h5>
          <p class="card-text">A modern art piece inspired by city life.</p>
        </div>
      </div>
    </div>
  </div>
</section>

<!-- About Us Section -->
<section class="container py-5">
  <div class="row text-center">
    <div class="col">
      <h2>About Us</h2>
      <p>
        The Art Exhibition team is passionate about showcasing creativity from around the world.  
        Our mission is to provide a platform where artists can display their talent and art lovers can discover inspiring masterpieces.  
        We believe that art is for everyone, and we strive to make it accessible, engaging, and memorable.
      </p>
    </div>
  </div>
</section>

<!-- Stylish Footer -->
<footer class="stylish-footer">
  <small>&copy; <?php echo date('Y'); ?> Art Exhibition. All Rights Reserved.</small>
</footer>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>