<?php
session_start();
include 'config.php';

// Check if user is logged in
if(!isset($_SESSION['user_id'])){
    header("Location: login.php");
    exit;
}

$user_id = $_SESSION['user_id'];

// Fetch user orders
$result = $conn->query("SELECT * FROM orders WHERE user_id=$user_id ORDER BY created_at DESC");
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>My Orders</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<style>
body { padding-top: 70px; }
</style>
</head>
<body>

<!-- Navbar -->
<nav class="navbar navbar-expand-lg navbar-dark bg-dark fixed-top">
  <div class="container">
    <a class="navbar-brand" href="dashboard.php">My Shop</a>
    <div class="collapse navbar-collapse" id="navbarNav">
      <ul class="navbar-nav ms-auto">
        <li class="nav-item"><a class="nav-link" href="dashboard.php">Products</a></li>
        <li class="nav-item"><a class="nav-link active" href="my_orders.php">📦 My Orders</a></li>
        <li class="nav-item"><a class="nav-link" href="logout.php">Logout</a></li>
      </ul>
    </div>
  </div>
</nav>

<div class="container py-4">
<h2 class="mb-4">My Orders</h2>

<?php if($result->num_rows > 0): ?>
    <?php while($order = $result->fetch_assoc()): ?>
        <div class="card mb-4">
            <div class="card-header">
                <strong>Order #<?= $order['order_id'] ?></strong> |
                <span class="text-muted"><?= date("d M Y h:i A", strtotime($order['created_at'])) ?></span>

                <!-- Status Badge -->
                <?php 
                    $status = strtolower($order['status']);
                    $badgeClass = "bg-secondary";
                    if($status == "pending") $badgeClass = "bg-warning text-dark";
                    if($status == "confirmed") $badgeClass = "bg-success";
                    if($status == "rejected") $badgeClass = "bg-danger";
                ?>
                <span class="badge <?= $badgeClass ?> ms-3"><?= ucfirst($status) ?></span>

                <span class="float-end">Total: ₹<?= number_format($order['total_amount'], 2) ?></span>
            </div>
            <div class="card-body">
                <h6>Delivery Address:</h6>
                <p><?= htmlspecialchars($order['delivery_address']) ?>,
                   <?= htmlspecialchars($order['delivery_city']) ?> - 
                   <?= htmlspecialchars($order['delivery_pincode']) ?></p>

                <h6>Payment Method:</h6>
                <p><?= htmlspecialchars($order['payment_method']) ?></p>

                <h6>Items:</h6>
                <table class="table table-sm">
                    <thead>
                        <tr>
                            <th>Product</th>
                            <th>Qty</th>
                            <th>Price</th>
                            <th>Subtotal</th>
                        </tr>
                    </thead>
                    <tbody>
                    <?php
                        $order_id = $order['order_id'];
                        $items = $conn->query("SELECT oi.*, p.name 
                            FROM order_items oi 
                            JOIN product p ON oi.product_id = p.id 
                            WHERE oi.order_id=$order_id");
                        while($item = $items->fetch_assoc()):
                    ?>
                        <tr>
                            <td><?= htmlspecialchars($item['name']) ?></td>
                            <td><?= $item['quantity'] ?></td>
                            <td>₹<?= number_format($item['price'], 2) ?></td>
                            <td>₹<?= number_format($item['subtotal'], 2) ?></td>
                        </tr>
                    <?php endwhile; ?>
                    </tbody>
                </table>
            </div>
        </div>
    <?php endwhile; ?>
<?php else: ?>
    <p>You have not placed any orders yet.</p>
<?php endif; ?>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
